
*============================================================================
*============================================================================
*Merge Data
*============================================================================
*============================================================================

clear
set more off


*Pew Religious Freedom 2007-2016
use "Datasets\PublicDataSet_ReligiousRestrictions_2007to2016.dta", clear
*only use 2010 because TWM is from 2011-2012
drop if Question_Year != 2010
rename Ctry_EditorialName icountry
save "Temp Religious Freedom.dta", replace

*Pew Religious Composition (only countries from World's Muslims and Latin American Surveys
import excel "Datasets\Pew Religious Composition - to merge.xls", sheet("Pew Religious Composition") firstrow clear
save "Temp Pew Religious Composition.dta", replace

*GDP per Capita from WB
import excel "Datasets\GDP per capita - to merge.xls", sheet("Sheet1") firstrow clear
replace icountry = "Egypt" if icountry == "Egypt, Arab Rep."
replace icountry = "Iran" if icountry == "Iran, Islamic Rep."
replace icountry = "Kyrgyzstan" if icountry == "Kyrgyz Republic"
replace icountry = "Palestinian Territories" if icountry == "West Bank and Gaza"
replace icountry = "Russia" if icountry == "Russian Federation"
save "Temp WB GDP per capita.dta", replace

*Polity IV
import excel "Datasets\Polity IV - to merge.xls", sheet("Sheet1") firstrow clear
replace icountry = "Bosnia and Herzegovina" if icountry == "Bosnia"
*only use 2010 because TWM is from 2011-2012
drop if year != 2010
save "Temp Polity IV.dta", replace


use "Datasets\2012-Pew-Religion-Worlds-Muslims_dataset.dta", clear
gen icountry = "NA"
replace icountry = "Afghanistan" if COUNTRY==1
replace icountry = "Albania" if COUNTRY==2
replace icountry = "Algeria" if COUNTRY==3
replace icountry = "Azerbaijan" if COUNTRY==4
replace icountry = "Bangladesh" if COUNTRY==5
replace icountry = "Bosnia and Herzegovina" if COUNTRY==6
replace icountry = "Egypt" if COUNTRY==7
replace icountry = "Indonesia" if COUNTRY==8
replace icountry = "Iran" if COUNTRY==9
replace icountry = "Iraq" if COUNTRY==10
replace icountry = "Jordan" if COUNTRY==11
replace icountry = "Kazakhstan" if COUNTRY==12
replace icountry = "Kosovo" if COUNTRY==13
replace icountry = "Kyrgyzstan" if COUNTRY==14
replace icountry = "Lebanon" if COUNTRY==15
replace icountry = "Malaysia" if COUNTRY==16
replace icountry = "Morocco" if COUNTRY==17
replace icountry = "Niger" if COUNTRY==18
replace icountry = "Pakistan" if COUNTRY==19
replace icountry = "Palestinian Territories" if COUNTRY==20
replace icountry = "Russia" if COUNTRY==21
replace icountry = "Tajikistan" if COUNTRY==22
replace icountry = "Thailand" if COUNTRY==23
replace icountry = "Tunisia" if COUNTRY==24
replace icountry = "Turkey" if COUNTRY==25
replace icountry = "Uzbekistan" if COUNTRY==26


*merge with Pew religious freedom
merge m:1 icountry using "Temp Religious Freedom.dta"
drop if _merge==2
drop _merge 

*merge with Pew Religious Composition
merge m:1 icountry using "Temp Pew Religious Composition.dta"
drop if _merge==2
drop _merge 

*merge with World Bank GDP per capita
merge m:1 icountry using "Temp WB GDP per capita.dta"
drop if _merge==2
drop _merge 

*merge with Polity IV
merge m:1 icountry using "Temp Polity IV.dta"
drop if _merge==2
drop _merge 


*rm "Merged Muslims - Pew.dta"
*save "Merged Muslims - Pew.dta"


rm "Temp Religious Freedom.dta"
rm "Temp Pew Religious Composition.dta"
rm "Temp WB GDP per capita.dta"
rm "Temp Polity IV.dta"
